/***************************************************************************
 *   Copyright (C) 2008 by Manuel Schrape                                  *
 *   manuel.schrape@gmx.de                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License.        *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <QFileDialog>
#include <QSettings>

#include "wdg_Settings.h"
#include "../Classes/ToolBox.h"

wdg_Settings::wdg_Settings(QWidget *parent) : QWidget(parent)
{
    setupUi(this);
    listWidget->setCurrentRow(0);

#ifndef _BETA_
#endif

    connect(pb_Load,   SIGNAL(clicked()), this, SLOT(slot_LoadParameter()));
    connect(pb_Save,   SIGNAL(clicked()), this, SLOT(slot_SaveParameter()));

    // Settings - Looping-Pfeile
    connect(tb_9_6,  SIGNAL(clicked()), this, SLOT(slot_tbUp()));
    connect(tb_9_7,  SIGNAL(clicked()), this, SLOT(slot_tbDown()));
    connect(tb_9_8,  SIGNAL(clicked()), this, SLOT(slot_tbLeft()));
    connect(tb_9_9,  SIGNAL(clicked()), this, SLOT(slot_tbRight()));

    // Settings - LED's J16
    connect(J16_0,  SIGNAL(clicked()), this, SLOT(slot_LEDtoValue()));
    connect(J16_1,  SIGNAL(clicked()), this, SLOT(slot_LEDtoValue()));
    connect(J16_2,  SIGNAL(clicked()), this, SLOT(slot_LEDtoValue()));
    connect(J16_3,  SIGNAL(clicked()), this, SLOT(slot_LEDtoValue()));
    connect(J16_4,  SIGNAL(clicked()), this, SLOT(slot_LEDtoValue()));
    connect(J16_5,  SIGNAL(clicked()), this, SLOT(slot_LEDtoValue()));
    connect(J16_6,  SIGNAL(clicked()), this, SLOT(slot_LEDtoValue()));
    connect(J16_7,  SIGNAL(clicked()), this, SLOT(slot_LEDtoValue()));

    // Settings - LED's J17
    connect(J17_0,  SIGNAL(clicked()), this, SLOT(slot_LEDtoValue()));
    connect(J17_1,  SIGNAL(clicked()), this, SLOT(slot_LEDtoValue()));
    connect(J17_2,  SIGNAL(clicked()), this, SLOT(slot_LEDtoValue()));
    connect(J17_3,  SIGNAL(clicked()), this, SLOT(slot_LEDtoValue()));
    connect(J17_4,  SIGNAL(clicked()), this, SLOT(slot_LEDtoValue()));
    connect(J17_5,  SIGNAL(clicked()), this, SLOT(slot_LEDtoValue()));
    connect(J17_6,  SIGNAL(clicked()), this, SLOT(slot_LEDtoValue()));
    connect(J17_7,  SIGNAL(clicked()), this, SLOT(slot_LEDtoValue()));

    connect(sb_11_1, SIGNAL(valueChanged(int)), this, SLOT(slot_ValuetoLED16(int)));
    connect(sb_11_3, SIGNAL(valueChanged(int)), this, SLOT(slot_ValuetoLED17(int)));
}

void wdg_Settings::set_Config(cSettings *pConfig)
{
    Config = pConfig;
}

void wdg_Settings::set_LED(QToolButton *ToolButton, bool On)
{
    if (ToolButton->text() == QString("0") && On)
    {
        ToolButton->setIcon(ToolBox::Icon(0));
        ToolButton->setText("1");
    }
    else if (ToolButton->text() == QString("1") && !On)
    {
        ToolButton->setIcon(ToolBox::Icon(4));
        ToolButton->setText("0");
    }
    else if (ToolButton->text() == QString("00") && On)
    {
        ToolButton->setIcon(ToolBox::Icon(0));
        ToolButton->setText("11");
    }
    else if (ToolButton->text() == QString("11") && !On)
    {
        ToolButton->setIcon(ToolBox::Icon(4));
        ToolButton->setText("00");
    }
}

void wdg_Settings::slot_LEDtoValue()
{
    QToolButton *ToolButton = (QToolButton*)sender();
    if (ToolButton->text() == QString("0"))
    {
        set_LED(ToolButton, true);
        sb_11_1->setValue(sb_11_1->value() + ToolButton->toolTip().toInt());
    }
    else if (ToolButton->text() == QString("1"))
    {
        set_LED(ToolButton);
        sb_11_1->setValue(sb_11_1->value() - ToolButton->toolTip().toInt());
    }
    else if (ToolButton->text() == QString("00"))
    {
        set_LED(ToolButton, true);
        sb_11_3->setValue(sb_11_3->value() + ToolButton->toolTip().toInt());
    }
    else if (ToolButton->text() == QString("11"))
    {
        set_LED(ToolButton);
        sb_11_3->setValue(sb_11_3->value() - ToolButton->toolTip().toInt());
    }
}

void wdg_Settings::slot_ValuetoLED16(int Wert)
{
    set_LED(J16_0);
    set_LED(J16_1);
    set_LED(J16_2);
    set_LED(J16_3);
    set_LED(J16_4);
    set_LED(J16_5);
    set_LED(J16_6);
    set_LED(J16_7);

    for (int a = 0; a < 8; a++)
    {
        if (Wert > 127)
        {
            set_LED(J16_0, true);
            Wert = Wert - 128;
        }
        if (Wert > 63)
        {
            set_LED(J16_1, true);
            Wert = Wert - 64;
        }
        if (Wert > 31)
        {
            set_LED(J16_2, true);
            Wert = Wert - 32;
        }
        if (Wert > 15)
        {
            set_LED(J16_3, true);
            Wert = Wert - 16;
        }
        if (Wert > 7)
        {
            set_LED(J16_4, true);
            Wert = Wert - 8;
        }
        if (Wert > 3)
        {
            set_LED(J16_5, true);
            Wert = Wert - 4;
        }
        if (Wert > 1)
        {
            set_LED(J16_6, true);
            Wert = Wert - 2;
        }
        if (Wert > 0)
        {
            set_LED(J16_7, true);
            Wert = Wert - 1;
        }
    }
}

void wdg_Settings::slot_ValuetoLED17(int Wert)
{
    set_LED(J17_0);
    set_LED(J17_1);
    set_LED(J17_2);
    set_LED(J17_3);
    set_LED(J17_4);
    set_LED(J17_5);
    set_LED(J17_6);
    set_LED(J17_7);

    for (int a = 0; a < 8; a++)
    {
        if (Wert > 127)
        {
            set_LED(J17_0, true);
            Wert = Wert - 128;
        }
        if (Wert > 63)
        {
            set_LED(J17_1, true);
            Wert = Wert - 64;
        }
        if (Wert > 31)
        {
            set_LED(J17_2, true);
            Wert = Wert - 32;
        }
        if (Wert > 15)
        {
            set_LED(J17_3, true);
            Wert = Wert - 16;
        }
        if (Wert > 7)
        {
            set_LED(J17_4, true);
            Wert = Wert - 8;
        }
        if (Wert > 3)
        {
            set_LED(J17_5, true);
            Wert = Wert - 4;
        }
        if (Wert > 1)
        {
            set_LED(J17_6, true);
            Wert = Wert - 2;
        }
        if (Wert > 0)
        {
            set_LED(J17_7, true);
            Wert = Wert - 1;
        }
    }
}

void wdg_Settings::slot_tbUp()
{
    if (tb_9_6->text() == QString("0"))
    {
        tb_9_6->setText("1");
    }
    else
    {
        tb_9_6->setText("0");
    }
}

void wdg_Settings::slot_tbDown()
{
    if (tb_9_7->text() == QString("0"))
    {
        tb_9_7->setText("1");
    }
    else
    {
        tb_9_7->setText("0");
    }
}

void wdg_Settings::slot_tbLeft()
{
    if (tb_9_8->text() == QString("0"))
    {
        tb_9_8->setText("1");
    }
    else
    {
        tb_9_8->setText("0");
    }
}

void wdg_Settings::slot_tbRight()
{
    if (tb_9_9->text() == QString("0"))
    {
        tb_9_9->setText("1");
    }
    else
    {
        tb_9_9->setText("0");
    }
}

void wdg_Settings::slot_LoadParameter() // DONE 0.75a
{
    QString Filename = QFileDialog::getOpenFileName(this, "Mikrokopter Parameter laden",  Config->DIR.Parameter + "/", "Mikrokopter Parameter(*.mkp);;Alle Dateien (*)");

    if (!Filename.isEmpty())
    {
        int Set = sb_Set->value();
        QSettings Setting(Filename, QSettings::IniFormat);

        Setting.beginGroup("Setup");
            QString Name = Setting.value("Name", QString("--noname--")).toString();
            char *CName = Name.toLatin1().data();
            int a;

            for (a=0; a < Name.length(); a++)
            {
                ParameterSet[Set][P_NAME+a] = CName[a];
            }
            while (a < 12)
            {
                ParameterSet[Set][P_NAME+a] = 0;
                a++;
            }

            ParameterSet[Set][P_GLOBAL_CONF] = Setting.value("GlobalConfig", 0).toInt();
        Setting.endGroup();

        Setting.beginGroup("Channels");
            ParameterSet[Set][P_KANAL_NICK]  = Setting.value("Nick", 1).toInt();
            ParameterSet[Set][P_KANAL_ROLL]  = Setting.value("Roll", 2).toInt();
            ParameterSet[Set][P_KANAL_GAS]   = Setting.value("Gas", 3).toInt();
            ParameterSet[Set][P_KANAL_GIER]  = Setting.value("Gier", 4).toInt();
            ParameterSet[Set][P_KANAL_POTI1] = Setting.value("Poti_1", 5).toInt();
            ParameterSet[Set][P_KANAL_POTI2] = Setting.value("Poti_2", 6).toInt();
            ParameterSet[Set][P_KANAL_POTI3] = Setting.value("Poti_3", 7).toInt();
            ParameterSet[Set][P_KANAL_POTI4] = Setting.value("Poti_4", 8).toInt();
        Setting.endGroup();

        Setting.beginGroup("Stick");
            ParameterSet[Set][P_STICK_P]  = Setting.value("Nick_Roll-P", 4).toInt();
            ParameterSet[Set][P_STICK_D]  = Setting.value("Nick_Roll-D", 8).toInt();
            ParameterSet[Set][P_GIER_P]   = Setting.value("Gier-P", 1).toInt();
            ParameterSet[Set][P_EXTERNAL] = Setting.value("ExternalControl", 1).toInt();
        Setting.endGroup();

        Setting.beginGroup("Altitude");
            ParameterSet[Set][P_MAXHOEHE]   = Setting.value("Setpoint", 251).toInt();
            ParameterSet[Set][P_MIN_GAS]    = Setting.value("MinGas", 30).toInt();
            ParameterSet[Set][P_HOEHE_P]    = Setting.value("P", 10).toInt();
            ParameterSet[Set][P_DRUCK_D]    = Setting.value("Barometric-D", 30).toInt();
            ParameterSet[Set][P_HOEHE_ACC]  = Setting.value("Z-ACC-Effect", 30).toInt();
            ParameterSet[Set][P_HOEHE_GAIN] = Setting.value("Gain", 3).toInt();
        Setting.endGroup();

        Setting.beginGroup("Gyro");
            ParameterSet[Set][P_GYRO_P]          = Setting.value("P", 80).toInt();
            ParameterSet[Set][P_GYRO_I]          = Setting.value("I", 120).toInt();
            ParameterSet[Set][P_GYRO_D]          = Setting.value("D", 0).toInt();
            ParameterSet[Set][P_DYNAMIC_STAB]    = Setting.value("DynamicStability", 75).toInt();
            ParameterSet[Set][P_GYRO_ACC_FAKTOR] = Setting.value("ACC_Gyro-Factor", 30).toInt();
            ParameterSet[Set][P_GYRO_ACC_ABGL]   = Setting.value("ACC_Gyro-Compensation", 32).toInt();
            ParameterSet[Set][P_DRIFT_KOMP]      = Setting.value("DriftCompensation", 4).toInt();
            ParameterSet[Set][P_FAKTOR_I]        = Setting.value("Main-I", 32).toInt();
        Setting.endGroup();

        Setting.beginGroup("Camera");
            ParameterSet[Set][P_SERVO_NICK_CONT]  = Setting.value("ServoNickControl", 100).toInt();
            ParameterSet[Set][P_SERVO_NICK_COMP]  = Setting.value("ServoNickCompensation", 40).toInt();
            ParameterSet[Set][P_SERVO_NICK_MIN]   = Setting.value("ServoNickMin", 50).toInt();
            ParameterSet[Set][P_SERVO_NICK_MAX]   = Setting.value("ServoNickMax", 150).toInt();

            ParameterSet[Set][P_SERVO_ROLL_CONT]  = Setting.value("ServoRollControl", 100).toInt();
            ParameterSet[Set][P_SERVO_ROLL_COMP]  = Setting.value("ServoRollCompensation", 40).toInt();
            ParameterSet[Set][P_SERVO_ROLL_MIN]   = Setting.value("ServoRollMin", 50).toInt();
            ParameterSet[Set][P_SERVO_ROLL_MAX]   = Setting.value("ServoRollMax", 150).toInt();

            ParameterSet[Set][P_SERVO_COMPI]      = Setting.value("ServoInvert", 0).toInt();

            ParameterSet[Set][P_SERVO_REFR]  = Setting.value("ServoNickRefreshRate", 5).toInt();
        Setting.endGroup();

        Setting.beginGroup("Others");
            ParameterSet[Set][P_GAS_MIN]         = Setting.value("MinGas", 8).toInt();
            ParameterSet[Set][P_GAS_MAX]         = Setting.value("MaxGas", 230).toInt();
            ParameterSet[Set][P_KOMPASS_WIRKUNG] = Setting.value("Compass-Effect", 128).toInt();
            ParameterSet[Set][P_UNTERSPANNUNG]   = Setting.value("UnderVoltage", 94).toInt();
            ParameterSet[Set][P_NOTGAS]          = Setting.value("NotGas", 35).toInt();
            ParameterSet[Set][P_NOTGASZEIT]      = Setting.value("NotGasTime", 30).toInt();
        Setting.endGroup();

        Setting.beginGroup("Coupling");
            ParameterSet[Set][P_ACHS_KOPPLUNG1]  = Setting.value("YawPosFeedback", 90).toInt();
            ParameterSet[Set][P_ACHS_KOPPLUNG2]  = Setting.value("NickRollFeedback", 90).toInt();
            ParameterSet[Set][P_ACHS_GKOPPLUNG] = Setting.value("YawCorrection", 5).toInt();
        Setting.endGroup();

        Setting.beginGroup("Loop");
            ParameterSet[Set][P_LOOP_CONFIG]    = Setting.value("Config", 0).toInt();
            ParameterSet[Set][P_LOOP_GAS_LIMIT] = Setting.value("GasLimit", 50).toInt();
            ParameterSet[Set][P_LOOP_THRESHOLD] = Setting.value("StickThreshold", 90).toInt();
            ParameterSet[Set][P_LOOP_HYSTERESE] = Setting.value("LoopHysteresis", 50).toInt();
            ParameterSet[Set][P_WINKEL_NICK]    = Setting.value("TurnOverNick", 85).toInt();
            ParameterSet[Set][P_WINKEL_ROLL]    = Setting.value("TurnOverRoll", 85).toInt();
        Setting.endGroup();

        Setting.beginGroup("User");
            ParameterSet[Set][P_USER_1] = Setting.value("Parameter_1", 0).toInt();
            ParameterSet[Set][P_USER_2] = Setting.value("Parameter_2", 0).toInt();
            ParameterSet[Set][P_USER_3] = Setting.value("Parameter_3", 0).toInt();
            ParameterSet[Set][P_USER_4] = Setting.value("Parameter_4", 0).toInt();
            ParameterSet[Set][P_USER_5] = Setting.value("Parameter_5", 0).toInt();
            ParameterSet[Set][P_USER_6] = Setting.value("Parameter_6", 0).toInt();
            ParameterSet[Set][P_USER_7] = Setting.value("Parameter_7", 0).toInt();
            ParameterSet[Set][P_USER_8] = Setting.value("Parameter_8", 0).toInt();
        Setting.endGroup();

        Setting.beginGroup("Output");
            ParameterSet[Set][P_J16_BITMASK] = Setting.value("J16_Bitmask", 255).toInt();
            ParameterSet[Set][P_J16_TIMING]  = Setting.value("J16_Timing", 251).toInt();
            ParameterSet[Set][P_J17_BITMASK] = Setting.value("J17_Bitmask", 255).toInt();
            ParameterSet[Set][P_J17_TIMING]  = Setting.value("J17_Timing", 251).toInt();
        Setting.endGroup();

        Setting.beginGroup("NaviCtrl");
            ParameterSet[Set][P_NAV_GPS_MODE]    = Setting.value("GPS_ModeControl", 253).toInt();
            ParameterSet[Set][P_NAV_GPS_GAIN]    = Setting.value("GPS_Gain", 100).toInt();
            ParameterSet[Set][P_NAV_GPS_P]       = Setting.value("GPS_P", 90).toInt();
            ParameterSet[Set][P_NAV_GPS_I]       = Setting.value("GPS_I", 90).toInt();
            ParameterSet[Set][P_NAV_GPS_D]       = Setting.value("GPS_D", 90).toInt();
            ParameterSet[Set][P_NAV_GPS_P_LIMIT] = Setting.value("GPS_P_Limit", 75).toInt();
            ParameterSet[Set][P_NAV_GPS_I_LIMIT] = Setting.value("GPS_I_Limit", 75).toInt();
            ParameterSet[Set][P_NAV_GPS_D_LIMIT] = Setting.value("GPS_D_Limit", 75).toInt();
            ParameterSet[Set][P_NAV_GPS_ACC]     = Setting.value("GPS_Acc", 0).toInt();
            ParameterSet[Set][P_NAV_GPS_MIN]     = Setting.value("GPS_MinSat", 6).toInt();
            ParameterSet[Set][P_NAV_STICK_THRE]  = Setting.value("GPS_StickThreshold", 8).toInt();
            ParameterSet[Set][P_NAV_WIND_CORR]   = Setting.value("GPS_WindCorrection", 90).toInt();
            ParameterSet[Set][P_NAV_SPEED_COMP]  = Setting.value("GPS_SpeedCompensation", 30).toInt();
            ParameterSet[Set][P_NAV_RADIUS]      = Setting.value("GPS_MaxRadius", 100).toInt();
            ParameterSet[Set][P_NAV_ANGLE_LIMIT] = Setting.value("GPS_AngleLimit", 60).toInt();
            ParameterSet[Set][P_NAV_PH_LOGINTIME] = Setting.value("GPS_PH_Login_Time", 4).toInt();
        Setting.endGroup();

        show_FCSettings(Set, ParameterSet[Set]);
    }
}

int wdg_Settings::get_Value(QComboBox *Combo)
{
    if (Combo->currentText() == QString("Poti 1"))
        return 251;
    if (Combo->currentText() == QString("Poti 2"))
        return 252;
    if (Combo->currentText() == QString("Poti 3"))
        return 253;
    if (Combo->currentText() == QString("Poti 4"))
        return 254;
    return Combo->currentText().toInt();
}

void wdg_Settings::store_ParameterSet(int Set) // DONE 0.75a
{
    char *Name = le_SetName->text().toLatin1().data();

    int a;

    for (a = 0; a < le_SetName->text().length(); a++)
    {
        ParameterSet[Set][P_NAME+a] = Name[a];
    }

    while(a < 12)
    {
        ParameterSet[Set][P_NAME+a] = 0;
        a++;
    }

    // Seite 1
    ParameterSet[Set][P_GLOBAL_CONF] = 0;

    if (cb_1_1->isChecked())
        ParameterSet[Set][P_GLOBAL_CONF] = ParameterSet[Set][P_GLOBAL_CONF] | 0x01;
    if (cb_1_2->isChecked())
        ParameterSet[Set][P_GLOBAL_CONF] = ParameterSet[Set][P_GLOBAL_CONF] | 0x02;
    if (cb_1_3->isChecked())
        ParameterSet[Set][P_GLOBAL_CONF] = ParameterSet[Set][P_GLOBAL_CONF] | 0x04;
    if (cb_1_4->isChecked())
        ParameterSet[Set][P_GLOBAL_CONF] = ParameterSet[Set][P_GLOBAL_CONF] | 0x08;
    if (cb_1_5->isChecked())
        ParameterSet[Set][P_GLOBAL_CONF] = ParameterSet[Set][P_GLOBAL_CONF] | 0x10;
    if (cb_1_6->isChecked())
        ParameterSet[Set][P_GLOBAL_CONF] = ParameterSet[Set][P_GLOBAL_CONF] | 0x20;
    if (cb_1_7->isChecked())
        ParameterSet[Set][P_GLOBAL_CONF] = ParameterSet[Set][P_GLOBAL_CONF] | 0x40;
    if (cb_1_8->isChecked())
        ParameterSet[Set][P_GLOBAL_CONF] = ParameterSet[Set][P_GLOBAL_CONF] | 0x80;

    // Seite 2
    ParameterSet[Set][P_KANAL_NICK]  = sb_2_1->value();
    ParameterSet[Set][P_KANAL_ROLL]  = sb_2_2->value();
    ParameterSet[Set][P_KANAL_GAS]   = sb_2_3->value();
    ParameterSet[Set][P_KANAL_GIER]  = sb_2_4->value();
    ParameterSet[Set][P_KANAL_POTI1] = sb_2_5->value();
    ParameterSet[Set][P_KANAL_POTI2] = sb_2_6->value();
    ParameterSet[Set][P_KANAL_POTI3] = sb_2_7->value();
    ParameterSet[Set][P_KANAL_POTI4] = sb_2_8->value();

    // Seite 3
    ParameterSet[Set][P_STICK_P]  = sb_3_1->value();
    ParameterSet[Set][P_STICK_D]  = sb_3_2->value();
    ParameterSet[Set][P_GIER_P]   = get_Value(cb_3_3);
    ParameterSet[Set][P_EXTERNAL] = get_Value(cb_3_4);

    // Seite 4
    ParameterSet[Set][P_MAXHOEHE]   = get_Value(cb_4_1);
    ParameterSet[Set][P_MIN_GAS]    = sb_4_2->value();
    ParameterSet[Set][P_HOEHE_P]    = get_Value(cb_4_3);
    ParameterSet[Set][P_DRUCK_D]    = get_Value(cb_4_4);
    ParameterSet[Set][P_HOEHE_ACC]  = get_Value(cb_4_5);
    ParameterSet[Set][P_HOEHE_GAIN] = sb_4_6->value();

    // Seite 5
    ParameterSet[Set][P_GYRO_P]          = get_Value(cb_5_1);
    ParameterSet[Set][P_GYRO_I]          = get_Value(cb_5_2);
    ParameterSet[Set][P_GYRO_D]          = get_Value(cb_5_8);
    ParameterSet[Set][P_DYNAMIC_STAB]    = get_Value(cb_5_3);
    ParameterSet[Set][P_GYRO_ACC_FAKTOR] = sb_5_4->value();
    ParameterSet[Set][P_GYRO_ACC_ABGL]   = sb_5_5->value();
    ParameterSet[Set][P_FAKTOR_I]        = get_Value(cb_5_6);
    ParameterSet[Set][P_DRIFT_KOMP]      = sb_5_7->value();

    // Seite 6
    ParameterSet[Set][P_SERVO_NICK_CONT]  = get_Value(cb_6_1);
    ParameterSet[Set][P_SERVO_NICK_COMP]  = sb_6_2->value();
    ParameterSet[Set][P_SERVO_NICK_MIN]   = sb_6_3->value();
    ParameterSet[Set][P_SERVO_NICK_MAX]   = sb_6_4->value();
//    ParameterSet[Set][P_SERVO_NICK_COMPI] = cb_6_6->isChecked();

    ParameterSet[Set][P_SERVO_ROLL_CONT]  = get_Value(cb_6_7);
    ParameterSet[Set][P_SERVO_ROLL_COMP]  = sb_6_8->value();
    ParameterSet[Set][P_SERVO_ROLL_MIN]   = sb_6_10->value();
    ParameterSet[Set][P_SERVO_ROLL_MAX]   = sb_6_11->value();

    ParameterSet[Set][P_SERVO_REFR]  = sb_6_5->value();

    if (cb_6_6->isChecked())
        ParameterSet[Set][P_SERVO_COMPI] = ParameterSet[Set][P_SERVO_COMPI] | 0x01;
    if (cb_6_9->isChecked())
        ParameterSet[Set][P_SERVO_COMPI] = ParameterSet[Set][P_SERVO_COMPI] | 0x02;

    // Seite 7
    ParameterSet[Set][P_GAS_MIN]         = sb_7_1->value();
    ParameterSet[Set][P_GAS_MAX]         = sb_7_2->value();
    ParameterSet[Set][P_KOMPASS_WIRKUNG] = get_Value(cb_7_3);
    ParameterSet[Set][P_UNTERSPANNUNG]   = sb_7_4->value();
    ParameterSet[Set][P_NOTGASZEIT]      = sb_7_5->value();
    ParameterSet[Set][P_NOTGAS]          = sb_7_6->value();

    // Seite 8
    ParameterSet[Set][P_ACHS_KOPPLUNG1]  = get_Value(cb_8_1);
    ParameterSet[Set][P_ACHS_KOPPLUNG2]  = get_Value(cb_8_2);
    ParameterSet[Set][P_ACHS_GKOPPLUNG]  = get_Value(cb_8_3);

    // Seite 9
    ParameterSet[Set][P_LOOP_CONFIG] = 0;
    if (tb_9_6->text() == QString("1"))
        ParameterSet[Set][P_LOOP_CONFIG] = ParameterSet[Set][P_LOOP_CONFIG] | 0x01;
    if (tb_9_7->text() == QString("1"))
        ParameterSet[Set][P_LOOP_CONFIG] = ParameterSet[Set][P_LOOP_CONFIG] | 0x02;
    if (tb_9_8->text() == QString("1"))
        ParameterSet[Set][P_LOOP_CONFIG] = ParameterSet[Set][P_LOOP_CONFIG] | 0x04;
    if (tb_9_9->text() == QString("1"))
        ParameterSet[Set][P_LOOP_CONFIG] = ParameterSet[Set][P_LOOP_CONFIG] | 0x08;


    ParameterSet[Set][P_LOOP_GAS_LIMIT] = get_Value(cb_9_1);
    ParameterSet[Set][P_LOOP_THRESHOLD] = sb_9_2->value();
    ParameterSet[Set][P_WINKEL_NICK]    = sb_9_3->value();
    ParameterSet[Set][P_LOOP_HYSTERESE] = sb_9_4->value();
    ParameterSet[Set][P_WINKEL_ROLL]    = sb_9_5->value();

    // Seite 10
    ParameterSet[Set][P_USER_1] = get_Value(cb_10_1);
    ParameterSet[Set][P_USER_2] = get_Value(cb_10_2);
    ParameterSet[Set][P_USER_3] = get_Value(cb_10_3);
    ParameterSet[Set][P_USER_4] = get_Value(cb_10_4);
    ParameterSet[Set][P_USER_5] = get_Value(cb_10_5);
    ParameterSet[Set][P_USER_6] = get_Value(cb_10_6);
    ParameterSet[Set][P_USER_7] = get_Value(cb_10_7);
    ParameterSet[Set][P_USER_8] = get_Value(cb_10_8);

    // Seite 11
    ParameterSet[Set][P_J16_BITMASK] = sb_11_1->value();
    ParameterSet[Set][P_J16_TIMING]  = get_Value(cb_11_2);
    ParameterSet[Set][P_J17_BITMASK] = sb_11_3->value();
    ParameterSet[Set][P_J17_TIMING]  = get_Value(cb_11_4);

    // Seite 12
    ParameterSet[Set][P_NAV_GPS_MODE]   = get_Value(cb_12_1);
    ParameterSet[Set][P_NAV_GPS_GAIN]   = get_Value(cb_12_2);
    ParameterSet[Set][P_NAV_STICK_THRE] = sb_12_3->value();
    ParameterSet[Set][P_NAV_GPS_MIN]    = sb_12_4->value();
    ParameterSet[Set][P_NAV_GPS_P]      = get_Value(cb_12_5);
    ParameterSet[Set][P_NAV_GPS_I]      = get_Value(cb_12_6);
    ParameterSet[Set][P_NAV_GPS_D]      = get_Value(cb_12_7);
    ParameterSet[Set][P_NAV_GPS_ACC]    = get_Value(cb_12_8);
    ParameterSet[Set][P_NAV_GPS_P_LIMIT] = get_Value(cb_12_9);
    ParameterSet[Set][P_NAV_GPS_I_LIMIT] = get_Value(cb_12_10);
    ParameterSet[Set][P_NAV_GPS_D_LIMIT] = get_Value(cb_12_11);

    //Seite 13
    ParameterSet[Set][P_NAV_WIND_CORR]    = get_Value(cb_13_1);
    ParameterSet[Set][P_NAV_SPEED_COMP]   = get_Value(cb_13_2);
    ParameterSet[Set][P_NAV_RADIUS]       = get_Value(cb_13_3);
    ParameterSet[Set][P_NAV_ANGLE_LIMIT]  = get_Value(cb_13_4);
    ParameterSet[Set][P_NAV_PH_LOGINTIME] = sb_13_5->value();
}

void wdg_Settings::slot_SaveParameter() // DONE 0.75a
{
    int Set = sb_Set->value() + 5;

    QString Filename = QFileDialog::getSaveFileName(this, "Mikrokopter Parameter speichern", Config->DIR.Parameter + "/" + Version + "_" + le_SetName->text(), "Mikrokopter Parameter(*.mkp);;Alle Dateien (*)");

    if (!Filename.isEmpty())
    {
        if (!(Filename.endsWith(".mkp", Qt::CaseInsensitive)))
        {
            Filename = Filename + QString(".mkp");
        }
        store_ParameterSet(Set);

        QSettings Setting(Filename, QSettings::IniFormat);

        Setting.beginGroup("Setup");
            Setting.setValue("Name",         le_SetName->text());
            Setting.setValue("GlobalConfig", ParameterSet[Set][P_GLOBAL_CONF]);
        Setting.endGroup();

        Setting.beginGroup("Channels");
            Setting.setValue("Nick",   ParameterSet[Set][P_KANAL_NICK]);
            Setting.setValue("Roll",   ParameterSet[Set][P_KANAL_ROLL]);
            Setting.setValue("Gas",    ParameterSet[Set][P_KANAL_GAS]);
            Setting.setValue("Gier",   ParameterSet[Set][P_KANAL_GIER]);
            Setting.setValue("Poti_1", ParameterSet[Set][P_KANAL_POTI1]);
            Setting.setValue("Poti_2", ParameterSet[Set][P_KANAL_POTI2]);
            Setting.setValue("Poti_3", ParameterSet[Set][P_KANAL_POTI3]);
            Setting.setValue("Poti_4", ParameterSet[Set][P_KANAL_POTI4]);
        Setting.endGroup();

        Setting.beginGroup("Stick");
            Setting.setValue("Nick_Roll-P",     ParameterSet[Set][P_STICK_P]);
            Setting.setValue("Nick_Roll-D",     ParameterSet[Set][P_STICK_D]);
            Setting.setValue("Gier-P",          ParameterSet[Set][P_GIER_P]);
            Setting.setValue("ExternalControl", ParameterSet[Set][P_EXTERNAL]);
        Setting.endGroup();

        Setting.beginGroup("Altitude");
            Setting.setValue("Setpoint",     ParameterSet[Set][P_MAXHOEHE]);
            Setting.setValue("MinGas",       ParameterSet[Set][P_MIN_GAS]);
            Setting.setValue("P",            ParameterSet[Set][P_HOEHE_P]);
            Setting.setValue("Barometric-D", ParameterSet[Set][P_DRUCK_D]);
            Setting.setValue("Z-ACC-Effect", ParameterSet[Set][P_HOEHE_ACC]);
            Setting.setValue("Gain",         ParameterSet[Set][P_HOEHE_GAIN]);
        Setting.endGroup();

        Setting.beginGroup("Gyro");
            Setting.setValue("P",                     ParameterSet[Set][P_GYRO_P]);
            Setting.setValue("I",                     ParameterSet[Set][P_GYRO_I]);
            Setting.setValue("D",                     ParameterSet[Set][P_GYRO_D]);
            Setting.setValue("DynamicStability",      ParameterSet[Set][P_DYNAMIC_STAB]);
            Setting.setValue("ACC_Gyro-Factor",       ParameterSet[Set][P_GYRO_ACC_FAKTOR]);
            Setting.setValue("ACC_Gyro-Compensation", ParameterSet[Set][P_GYRO_ACC_ABGL]);
            Setting.setValue("DriftCompensation",     ParameterSet[Set][P_DRIFT_KOMP]);
            Setting.setValue("Main-I",                ParameterSet[Set][P_FAKTOR_I]);
        Setting.endGroup();

        Setting.beginGroup("Camera");
            Setting.setValue("ServoNickControl",      ParameterSet[Set][P_SERVO_NICK_CONT]);
            Setting.setValue("ServoNickCompensation", ParameterSet[Set][P_SERVO_NICK_COMP]);
            Setting.setValue("ServoNickMin",          ParameterSet[Set][P_SERVO_NICK_MIN]);
            Setting.setValue("ServoNickMax",          ParameterSet[Set][P_SERVO_NICK_MAX]);

            Setting.setValue("ServoRollControl",      ParameterSet[Set][P_SERVO_ROLL_CONT]);
            Setting.setValue("ServoRollCompensation", ParameterSet[Set][P_SERVO_ROLL_COMP]);
            Setting.setValue("ServoRollMin",          ParameterSet[Set][P_SERVO_ROLL_MIN]);
            Setting.setValue("ServoRollMax",          ParameterSet[Set][P_SERVO_ROLL_MAX]);

            Setting.setValue("ServoInvert",           ParameterSet[Set][P_SERVO_COMPI]);
            Setting.setValue("ServoNickRefreshRate",  ParameterSet[Set][P_SERVO_REFR]);
        Setting.endGroup();

        Setting.beginGroup("Others");
            Setting.setValue("MinGas",         ParameterSet[Set][P_GAS_MIN]);
            Setting.setValue("MaxGas",         ParameterSet[Set][P_GAS_MAX]);
            Setting.setValue("Compass-Effect", ParameterSet[Set][P_KOMPASS_WIRKUNG]);
            Setting.setValue("UnderVoltage",   ParameterSet[Set][P_UNTERSPANNUNG]);
            Setting.setValue("NotGas",         ParameterSet[Set][P_NOTGAS]);
            Setting.setValue("NotGasTime",     ParameterSet[Set][P_NOTGASZEIT]);
        Setting.endGroup();

        Setting.beginGroup("Coupling");
            Setting.setValue("YawPosFeedback", ParameterSet[Set][P_ACHS_KOPPLUNG1]);
            Setting.setValue("YawNegFeedback", ParameterSet[Set][P_ACHS_GKOPPLUNG]);
        Setting.endGroup();

        Setting.beginGroup("Loop");
            Setting.setValue("Config", ParameterSet[Set][P_LOOP_CONFIG]);
            Setting.setValue("GasLimit", ParameterSet[Set][P_LOOP_GAS_LIMIT]);
            Setting.setValue("StickThreshold", ParameterSet[Set][P_LOOP_THRESHOLD]);
            Setting.setValue("LoopHysteresis", ParameterSet[Set][P_LOOP_HYSTERESE]);
            Setting.setValue("TurnOverNick", ParameterSet[Set][P_WINKEL_NICK]);
            Setting.setValue("TurnOverRoll", ParameterSet[Set][P_WINKEL_ROLL]);
        Setting.endGroup();

        Setting.beginGroup("User");
             Setting.setValue("Parameter_1", ParameterSet[Set][P_USER_1]);
             Setting.setValue("Parameter_2", ParameterSet[Set][P_USER_2]);
             Setting.setValue("Parameter_3", ParameterSet[Set][P_USER_3]);
             Setting.setValue("Parameter_4", ParameterSet[Set][P_USER_4]);
             Setting.setValue("Parameter_5", ParameterSet[Set][P_USER_5]);
             Setting.setValue("Parameter_6", ParameterSet[Set][P_USER_6]);
             Setting.setValue("Parameter_7", ParameterSet[Set][P_USER_7]);
             Setting.setValue("Parameter_8", ParameterSet[Set][P_USER_8]);
        Setting.endGroup();

        Setting.beginGroup("Output");
            Setting.setValue("J16_Bitmask", ParameterSet[Set][P_J16_BITMASK]);
            Setting.setValue("J16_Timing",  ParameterSet[Set][P_J16_TIMING]);
            Setting.setValue("J17_Bitmask", ParameterSet[Set][P_J17_BITMASK]);
            Setting.setValue("J17_Timing",  ParameterSet[Set][P_J17_TIMING]);
        Setting.endGroup();

        Setting.beginGroup("NaviCtrl");
            Setting.setValue("GPS_ModeControl",       ParameterSet[Set][P_NAV_GPS_MODE]);
            Setting.setValue("GPS_Gain",              ParameterSet[Set][P_NAV_GPS_GAIN]);
            Setting.setValue("GPS_P",                 ParameterSet[Set][P_NAV_GPS_P]);
            Setting.setValue("GPS_I",                 ParameterSet[Set][P_NAV_GPS_I]);
            Setting.setValue("GPS_D",                 ParameterSet[Set][P_NAV_GPS_D]);
            Setting.setValue("GPS_Acc",               ParameterSet[Set][P_NAV_GPS_ACC]);
            Setting.setValue("GPS_MinSat",            ParameterSet[Set][P_NAV_GPS_MIN]);
            Setting.setValue("GPS_StickThreshold",    ParameterSet[Set][P_NAV_STICK_THRE]);
            Setting.setValue("GPS_WindCorrection",    ParameterSet[Set][P_NAV_WIND_CORR]);
            Setting.setValue("GPS_SpeedCompensation", ParameterSet[Set][P_NAV_SPEED_COMP]);
            Setting.setValue("GPS_MaxRadius",         ParameterSet[Set][P_NAV_RADIUS]);
            Setting.setValue("GPS_AngleLimit",        ParameterSet[Set][P_NAV_ANGLE_LIMIT]);
        Setting.endGroup();
    }
}

char *wdg_Settings::GetFCSettings() // DONE 0.71g
{
    store_ParameterSet(sb_Set->value());

    char *TX_Data = new char[150];

    TX_Data[0] = sb_Set->value();
    TX_Data[1] = VERSION_SETTINGS;

    for (int a = 0; a < MaxParameter; a++)
    {
        TX_Data[a + 2] = ParameterSet[sb_Set->value()][a];
    }

    return TX_Data;

//    store_ParameterSet(sb_Set->value());

//    send_Data('s', ADDRESS_FC, TX_Data, MaxParameter + 2, false);
}

QComboBox *wdg_Settings::setCombo(QComboBox *Combo, int Set, int Wert)
{
    Set = Set;

    if (Wert <= 250)
    {
        Combo->setItemText(4, QString("%1").arg(Wert));
        Combo->setCurrentIndex(4);
    }
    else
    {
        Combo->setCurrentIndex(Wert - 251);
    }
    return Combo;
}

void wdg_Settings::show_FCSettings(int Set, int FCSettings[MaxParameter]) // DONE 0.71h
{
    memcpy(Settings, FCSettings, sizeof(FCSettings));

    memcpy(ParameterSet[Set], FCSettings, sizeof(FCSettings));

    sb_Set->setValue(Set);

    char Name[12];
    for (int a = 0; a < 12; a++)
    {
        Name[a] = FCSettings[P_NAME+a];
    }
    le_SetName->setText(QString(Name));


    // Seite 1
{
    cb_1_1->setChecked(FCSettings[P_GLOBAL_CONF] & 0x01);
    cb_1_2->setChecked(FCSettings[P_GLOBAL_CONF] & 0x02);
    cb_1_3->setChecked(FCSettings[P_GLOBAL_CONF] & 0x04);
    cb_1_4->setChecked(FCSettings[P_GLOBAL_CONF] & 0x08);
    cb_1_5->setChecked(FCSettings[P_GLOBAL_CONF] & 0x10);
    cb_1_6->setChecked(FCSettings[P_GLOBAL_CONF] & 0x20);
    cb_1_7->setChecked(FCSettings[P_GLOBAL_CONF] & 0x40);
    cb_1_8->setChecked(FCSettings[P_GLOBAL_CONF] & 0x80);
}
    // Seite 2
{
    sb_2_1->setValue(FCSettings[P_KANAL_NICK]);
    sb_2_2->setValue(FCSettings[P_KANAL_ROLL]);
    sb_2_3->setValue(FCSettings[P_KANAL_GAS]);
    sb_2_4->setValue(FCSettings[P_KANAL_GIER]);
    sb_2_5->setValue(FCSettings[P_KANAL_POTI1]);
    sb_2_6->setValue(FCSettings[P_KANAL_POTI2]);
    sb_2_7->setValue(FCSettings[P_KANAL_POTI3]);
    sb_2_8->setValue(FCSettings[P_KANAL_POTI4]);
}
    // Seite 3
{
    sb_3_1->setValue(FCSettings[P_STICK_P]);
    sb_3_2->setValue(FCSettings[P_STICK_D]);
    cb_3_3 = setCombo(cb_3_3, Set, FCSettings[P_GIER_P]);
    cb_3_4 = setCombo(cb_3_4, Set, FCSettings[P_EXTERNAL]);
}
    // Seite 4
{
    cb_4_1 = setCombo(cb_4_1, Set, FCSettings[P_MAXHOEHE]);
    sb_4_2->setValue(FCSettings[P_MIN_GAS]);
    cb_4_3 = setCombo(cb_4_3, Set, FCSettings[P_HOEHE_P]);
    cb_4_4 = setCombo(cb_4_4, Set, FCSettings[P_DRUCK_D]);
    cb_4_5 = setCombo(cb_4_5, Set, FCSettings[P_HOEHE_ACC]);
    sb_4_6->setValue(FCSettings[P_HOEHE_GAIN]);
//    cb_4_7->setChecked(FCSettings[P_LOOP_CONFIG] & 0x10);
}
    // Seite 5
{
    cb_5_1 = setCombo(cb_5_1, Set, FCSettings[P_GYRO_P]);
    cb_5_2 = setCombo(cb_5_2, Set, FCSettings[P_GYRO_I]);
    cb_5_8 = setCombo(cb_5_8, Set, FCSettings[P_GYRO_D]);
    cb_5_3 = setCombo(cb_5_3, Set, FCSettings[P_DYNAMIC_STAB]);
    sb_5_4->setValue(FCSettings[P_GYRO_ACC_FAKTOR]);
    sb_5_5->setValue(FCSettings[P_GYRO_ACC_ABGL]);
    cb_5_6 = setCombo(cb_5_6, Set, FCSettings[P_FAKTOR_I]);
    sb_5_7->setValue(FCSettings[P_DRIFT_KOMP]);
}
    // Seite 6
{
    cb_6_1 = setCombo(cb_6_1, Set, FCSettings[P_SERVO_NICK_CONT]);
    sb_6_2->setValue(FCSettings[P_SERVO_NICK_COMP]);
    sb_6_3->setValue(FCSettings[P_SERVO_NICK_MIN]);
    sb_6_4->setValue(FCSettings[P_SERVO_NICK_MAX]);

    cb_6_7 = setCombo(cb_6_7, Set, FCSettings[P_SERVO_ROLL_CONT]);
    sb_6_8->setValue(FCSettings[P_SERVO_ROLL_COMP]);
    sb_6_10->setValue(FCSettings[P_SERVO_ROLL_MIN]);
    sb_6_11->setValue(FCSettings[P_SERVO_ROLL_MAX]);

    cb_6_6->setChecked(FCSettings[P_SERVO_COMPI] & 0x01);
    cb_6_9->setChecked(FCSettings[P_SERVO_COMPI] & 0x02);

    sb_6_5->setValue(FCSettings[P_SERVO_REFR]);
}
    // Seite 7
{
    sb_7_1->setValue(FCSettings[P_GAS_MIN]);
    sb_7_2->setValue(FCSettings[P_GAS_MAX]);
    cb_7_3 = setCombo(cb_7_3, Set, FCSettings[P_KOMPASS_WIRKUNG]);
    sb_7_4->setValue(FCSettings[P_UNTERSPANNUNG]);
    sb_7_5->setValue(FCSettings[P_NOTGASZEIT]);
    sb_7_6->setValue(FCSettings[P_NOTGAS]);
}
    // Seite 8
{
    cb_8_1 = setCombo(cb_8_1, Set, FCSettings[P_ACHS_KOPPLUNG1]);
    cb_8_2 = setCombo(cb_8_2, Set, FCSettings[P_ACHS_KOPPLUNG2]);
    cb_8_3 = setCombo(cb_8_3, Set, FCSettings[P_ACHS_GKOPPLUNG]);
}
    // Seite 9
{
    if (FCSettings[P_LOOP_CONFIG] & 0x01)
    {
        tb_9_6->setText("1");
        tb_9_6->setChecked(true);
    }
    else
    {
        tb_9_6->setText("0");
        tb_9_6->setChecked(false);
    }

    if (FCSettings[P_LOOP_CONFIG] & 0x02)
    {
        tb_9_7->setText("1");
        tb_9_7->setChecked(true);
    }
    else
    {
        tb_9_7->setText("0");
        tb_9_7->setChecked(false);
    }

    if (FCSettings[P_LOOP_CONFIG] & 0x04)
    {
        tb_9_8->setText("1");
        tb_9_8->setChecked(true);
    }
    else
    {
        tb_9_8->setText("0");
        tb_9_8->setChecked(false);
    }

    if (FCSettings[P_LOOP_CONFIG] & 0x08)
    {
        tb_9_9->setText("1");
        tb_9_9->setChecked(true);
    }
    else
    {
        tb_9_9->setText("0");
        tb_9_9->setChecked(false);
    }

    cb_9_1 = setCombo(cb_9_1, Set, FCSettings[P_LOOP_GAS_LIMIT]);
    sb_9_2->setValue(FCSettings[P_LOOP_THRESHOLD]);
    sb_9_3->setValue(FCSettings[P_WINKEL_NICK]);
    sb_9_4->setValue(FCSettings[P_LOOP_HYSTERESE]);
    sb_9_5->setValue(FCSettings[P_WINKEL_ROLL]);
}
    // Seite 10
{
    cb_10_1 = setCombo(cb_10_1, Set, FCSettings[P_USER_1]);
    cb_10_2 = setCombo(cb_10_2, Set, FCSettings[P_USER_2]);
    cb_10_3 = setCombo(cb_10_3, Set, FCSettings[P_USER_3]);
    cb_10_4 = setCombo(cb_10_4, Set, FCSettings[P_USER_4]);
    cb_10_5 = setCombo(cb_10_5, Set, FCSettings[P_USER_5]);
    cb_10_6 = setCombo(cb_10_6, Set, FCSettings[P_USER_6]);
    cb_10_7 = setCombo(cb_10_7, Set, FCSettings[P_USER_7]);
    cb_10_8 = setCombo(cb_10_8, Set, FCSettings[P_USER_8]);
}
    // Seite 11
{
    sb_11_1->setValue(FCSettings[P_J16_BITMASK]);
    cb_11_2 = setCombo(cb_11_2, Set, FCSettings[P_J16_TIMING]);
    sb_11_3->setValue(FCSettings[P_J17_BITMASK]);
    cb_11_4 = setCombo(cb_11_4, Set, FCSettings[P_J17_TIMING]);
}
    // Seite 12
{
    cb_12_1 = setCombo(cb_12_1, Set, FCSettings[P_NAV_GPS_MODE]);
    cb_12_2 = setCombo(cb_12_2, Set, FCSettings[P_NAV_GPS_GAIN]);
    sb_12_3->setValue(FCSettings[P_NAV_STICK_THRE]);
    sb_12_4->setValue(FCSettings[P_NAV_GPS_MIN]);
    cb_12_5 = setCombo(cb_12_5, Set, FCSettings[P_NAV_GPS_P]);
    cb_12_6 = setCombo(cb_12_6, Set, FCSettings[P_NAV_GPS_I]);
    cb_12_7 = setCombo(cb_12_7, Set, FCSettings[P_NAV_GPS_D]);
    cb_12_8 = setCombo(cb_12_8, Set, FCSettings[P_NAV_GPS_ACC]);
    cb_12_9 = setCombo(cb_12_9, Set, FCSettings[P_NAV_GPS_P_LIMIT]);
    cb_12_10 = setCombo(cb_12_10, Set, FCSettings[P_NAV_GPS_I_LIMIT]);
    cb_12_11 = setCombo(cb_12_11, Set, FCSettings[P_NAV_GPS_D_LIMIT]);
}
    // Seite 13
{
    cb_13_1 = setCombo(cb_13_1, Set, FCSettings[P_NAV_WIND_CORR]);
    cb_13_2 = setCombo(cb_13_2, Set, FCSettings[P_NAV_SPEED_COMP]);
    cb_13_3 = setCombo(cb_13_3, Set, FCSettings[P_NAV_RADIUS]);
    cb_13_4 = setCombo(cb_13_4, Set, FCSettings[P_NAV_ANGLE_LIMIT]);
    sb_13_5->setValue(FCSettings[P_NAV_PH_LOGINTIME]);
}
}

wdg_Settings::~wdg_Settings()
{
}

